#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>

#include "dos33.h"


typedef struct dfilestruct
{
 struct dfilestruct *next;
 u8 catalog_track;
 u8 catalog_sector;
 u8 catalog_index; // 0..6
 u8 filetype;
 char ft;
 char filename[32];
 u8 first_tsl_track;
 u8 first_tsl_sector;
 int bits;
} __attribute__((packed))DFILE;


#define TRACKS_PER_DISK 0x23
#define SECTORS_PER_TRACK 0x10
#define BYTES_PER_SECTOR 0x100
#define TWO_BYTES_TO_SHORT(__x,__y) ((((int)__y)<<8)+__x)
#define DISK_SEEK(__track,__sector) fseek(fil,((__track*SECTORS_PER_TRACK)+__sector)*BYTES_PER_SECTOR,SEEK_SET)

#define DEBUGFILENAME 1


DFILE *dfilebase = NULL;


/////////////////////////////////////////////////////////////
////

int dump_vtol(struct dos33_vtol *vtoc)
{
 {
 printf("VTOC\n");
 printf("\tFour: %x\n", vtoc -> four);
 printf("\tT/S of first catalog sector: %x %x\n", vtoc -> catalog_track, vtoc -> catalog_sector);
 printf("\tDOS Version 3.%x\n", vtoc -> dos_version);
 printf("\tVolume Number %d\n", vtoc -> volume);
 printf("\tMax num T/S pairs in each S of T/S list: %d ($%x)\n", vtoc -> ts_pairs, vtoc -> ts_pairs);
 printf("\tLast track where sectors are allocated: %d ($%x)\n", vtoc -> last_track, vtoc -> last_track);
 printf("\tDirection of allocation: %s ($%x)\n", vtoc -> allocation_direction == 0xff ? "OUT" : "IN", vtoc -> allocation_direction);
 printf("\tNum of tracks per disk: %d ($%x)\n", vtoc -> tracks_per_disk, vtoc -> tracks_per_disk);
 printf("\tNum of sectors per track: %d ($%x)\n", vtoc -> sectors_per_track, vtoc -> sectors_per_track);
 printf("\tNum of bytes per sector: %d ($%x)\n", vtoc -> bytes_per_sector, vtoc -> bytes_per_sector);
 }
 return 0;
}


/////////////////////////////////////////////////////////////
////

int dump_catalog(struct dos33_catalog_sector *catalog)
{
 int i;
 int j;
 char temp_string[0x20];

 {
 printf("Catalog:\n");
 printf("\tNext track: 0x%x\n", catalog -> next_track);
 printf("\tNext sector: 0x%x\n", catalog -> next_sector);
 for (i = 0; i < 7; i++)
 {
	for (j = 0; j < 0x1e; j++)
	{
 temp_string[j] = catalog -> files[i].file_name[j] & 0x7f;
	}
	temp_string[0x1d] = 0;
	printf("\t%i: 0x%x/0x%x 0%x %s size 0x%x\n", 
		i, 
 catalog -> files[i].first_tsl_track, 
 catalog -> files[i].first_tsl_sector, 
 catalog -> files[i].file_type, 
 temp_string, 
 catalog -> files[i].num_sectors);
 }
 }
 return 0;
}


/////////////////////////////////////////////////////////////
////

int dump_tsl(struct dos33_ts_list *tsl)
{
 int i;

 {
 printf("TSL\n");
 printf("\tNext: %x/%x\n", tsl -> next.track, tsl -> next.sector);
 printf("\tDepth: %i\n", tsl -> current_sectors_deep);
 for (i = 0; i < 122; i++)
 {
	printf("\t0x%2x: 0x%x/0x%x\n", i, tsl -> data_location[i].track, 
 tsl -> data_location[i].sector);
 }
 }
 return 0;
}


/////////////////////////////////////////////////////////////
////

void verify_filename(char *s)
{
	int i;

	for (i = 0; i < strlen(s); i++)
	{
		switch (s[i])
		{
		case '/':
			s[i] = '_';
		}
	}
}


/////////////////////////////////////////////////////////////
////

void extract_file(FILE *fil,DFILE *df,char *filename)
{
	FILE *fil2;
	struct dos33_catalog_sector catalog;
	struct dos33_ts_list tsl;
	int file_to_get = df -> catalog_index;
	int catalog_sector;
	int catalog_track;
	int i;
	unsigned char data[256];
	unsigned char temp_track;
	unsigned char temp_sector;

	fil2 = fopen(filename, "wb");
	catalog_track = df -> catalog_track;
	catalog_sector = df -> catalog_sector;

//printf(" ct %d cs %d index %d\n",catalog_track,catalog_sector,file_to_get);
	DISK_SEEK(catalog_track, catalog_sector);
	fread(&catalog, 256, 1, fil);
	temp_track = catalog.files[file_to_get].first_tsl_track;
	temp_sector = catalog.files[file_to_get].first_tsl_sector;

	do
	{
//printf(" TSL @ read track %d read sector %d\n",temp_track,temp_sector);
		DISK_SEEK(temp_track, temp_sector);
		fread(&tsl, 256, 1, fil);
//		dump_tsl(&tsl);

		// check for file size?

//printf(" * reading %d sectors\n",catalog.files[file_to_get].num_sectors);
		for (i = 0; i < 122; i++) // catalog.files[file_to_get].num_sectors; i++)
		{
			if (!tsl.data_location[i].track && !tsl.data_location[i].sector)
			{
				fseek(fil2, 256, SEEK_CUR);
			}
			else
			{
				DISK_SEEK(tsl.data_location[i].track, tsl.data_location[i].sector);
				fread(&data, 256, 1, fil);
				fwrite(&data, 256, 1, fil2);
			}
		}
		if (tsl.next.track != temp_track || tsl.next.sector != temp_sector)
		{
			temp_track = tsl.next.track;
			temp_sector = tsl.next.sector;
		}
		else
		{
			temp_track = 0;
			temp_sector = 0;
		}
	} while (temp_track != 0);
	fclose(fil2);
	i = 0644;
	if (df -> bits & 1)
		i += 0100;
	if (df -> bits & 2)
		i += 010;
	if (df -> bits & 4)
		i += 01;
	chmod(filename, i);
}


/////////////////////////////////////////////////////////////
////

int main(int argc, char **argv)
{
	FILE *fil;
	DFILE		*df;
	DFILE		*tmpdf;
	struct dos33_vtol vtoc;
	struct dos33_catalog_sector catalog;
	int i;
	int j;
	int catalog_sector;
	int catalog_track;
	int loop;
	int x;
	unsigned char	data[256];
	char dirname[256];

	if (argc < 2)
	{
		printf("Usage %s <image name [*.dsk]>\n", argv[0]);
		return -1;
	}

	for (loop = 1; loop < argc; loop++)
	{
		fil = fopen(argv[loop], "rb");
		if (fil == NULL)
		{
			printf("Could not open %s!\n", argv[loop]);
			return -1;
		}
		printf("Disk image: %s\n",argv[loop]);

		// READ VTOC
		DISK_SEEK(0x11, 0x00);
		fread(&vtoc, 256, 1, fil);

		// Read catalog
		catalog_track = vtoc.catalog_track;
		catalog_sector = vtoc.catalog_sector;

		while (catalog_track || catalog_sector)
		{
			if (catalog_track > 39 || catalog_sector > 15)
			{
				printf("Is this really a dos 3.3 disk?\n");
				dfilebase = NULL;
				break;
			}

			// read catalog sector
			DISK_SEEK(catalog_track, catalog_sector);
			fread(&catalog, 256, 1, fil);

			for (i = 0; i < 7; i++)
			{
				if (!*catalog.files[i].file_name)
				{
					break;
				}
				if (catalog.files[i].first_tsl_track == 255) // deleted
				{
					break;
				}
				df = (DFILE *)malloc(sizeof(DFILE));
				df -> catalog_track = catalog_track;
				df -> catalog_sector = catalog_sector;
				df -> catalog_index = i;
				df -> filetype = catalog.files[i].file_type;
				df -> ft = 0;
				*df -> filename = 0;
				df -> first_tsl_track = catalog.files[i].first_tsl_track;
				df -> first_tsl_sector = catalog.files[i].first_tsl_sector;
				df -> next = dfilebase;
				dfilebase = df;
				if (catalog.files[i].file_type >= 0x80)
				{
					printf("*");
				}
				else
				{
					printf(" ");
				}
				switch (catalog.files[i].file_type & 0x7f)
				{
// bits 0 .. 7 = tiabsrab
				case 0:
					df -> ft = 'T';
					printf("T");
					df -> bits = 0;
					break;
				case 1:
					df -> ft = 'I';
					printf("I");
					df -> bits = 1;
					break;
				case 2:
					df -> ft = 'A';
					printf("A");
					df -> bits = 2;
					break;
				case 4:
					df -> ft = 'B';
					printf("B");
					df -> bits = 3;
					break;
				case 8:
					df -> ft = 'S';
					printf("S");
					df -> bits = 4;
					break;
				case 0x10:
					df -> ft = 'R';
					printf("R");
					df -> bits = 5;
					break;
				case 0x20:
					df -> ft = 'A';
					printf("A");
					df -> bits = 6;
					break;
				case 0x40:
					df -> ft = 'B';
					printf("B");
					df -> bits = 7;
					break;
				default:
					printf(" *** unknown file type 0x%02x ***\n", catalog.files[i].file_type & 0x7f);
					printf("Is this really a dos 3.3 disk?\n");
					dfilebase = NULL;
					catalog.next_track = catalog.next_sector = 0;
					break;
				} // switch()

				printf(" %3d ", catalog.files[i].num_sectors);
				for (j = 0; j < 0x1e - DEBUGFILENAME; j++)
				{
					printf("%c", catalog.files[i].file_name[j] & 0x7f);
					df -> filename[j] = catalog.files[i].file_name[j] & 0x7f;
				}
				df -> filename[j] = 0;
				printf("\n");
				while (df -> filename[strlen(df -> filename) - 1] == ' ')
				{
					df -> filename[strlen(df -> filename) - 1] = 0;
				}
			}
			catalog_track = catalog.next_track;
			catalog_sector = catalog.next_sector;
		}

		// get files
		if (dfilebase)
		{
			strcpy(dirname,argv[loop]);
			x = -1;
			for (i = 0; i < strlen(dirname); i++)
				if (dirname[i] == '.')
					x = i;
			if (x > -1)
				dirname[x] = 0;
			mkdir(dirname, 0755);
		}
		for (df = dfilebase; df; df = tmpdf)
		{
			if (*df -> filename)
			{
				verify_filename(df -> filename);
				sprintf(data,"%s/%s",dirname,df -> filename);
				extract_file(fil, df, data);
			}
			tmpdf = df -> next;
			free(df);
		}
		dfilebase = NULL;

		fclose(fil);
	} // for (loop)
	return 0;
}

